 <?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Sanitize inputs
    $name         = htmlspecialchars(trim($_POST['name']));
    $email        = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $phone        = htmlspecialchars(trim($_POST['phone']));
    $inquiry_type = htmlspecialchars(trim($_POST['inquiry_type']));
    $message      = htmlspecialchars(trim($_POST['message']));
    $position     = htmlspecialchars(trim($_POST['position']));

    // Basic validation
    if (empty($name) || empty($email) || empty($phone) || empty($message)) {
        echo "? Please fill in all required fields.";
        exit;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo "? Invalid email format.";
        exit;
    }

    // Email details
    $to = "mehak.nayyab786@gmail.com"; // ? change this to your email
    $subject = "Business Consulting $name";
    $body = "
    <h2>New Consulting Inquiry</h2>
    <p><strong>Name:</strong> $name</p>
    <p><strong>Email:</strong> $email</p>
    <p><strong>Phone:</strong> $phone</p>
    <p><strong>Inquiry Type:</strong> $inquiry_type</p>
    <p><strong>Position:</strong> $position</p>
    <p><strong>Message:</strong><br>$message</p>
    ";

    $headers  = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: $name <$email>" . "\r\n";

    // Send email
    if (mail($to, $subject, $body, $headers)) {
        echo "Thank you, $name! Your inquiry has been sent successfully.";
    } else {
        echo "Sorry, something went wrong. Please try again later.";
    }
} else {
    echo "?? Invalid request.";
}
?>
